using System;
using System.Runtime.Serialization;
using System.Security.Permissions;
using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.BOL
{
    
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/20/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		/// <summary>
		/// Exception class for Invoice-specific operations
		/// </summary>
		#endregion

	public class InvoiceException : BusinessObjectException
	{
        ///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/20/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="955"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Valid InvoiceException object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="352"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Empty InvoiceException class constructor
		/// </summary>
        public InvoiceException() : base()
		{

		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1203"> 
		///		<ExpectedInput>Message input string</ExpectedInput>
		///		<ExpectedOutput>Valid Invoice exception class with input string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1746"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>Generic exception message</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// InvoiceException class constructor
		/// </summary>
		/// <param name="message">string</param>
        public InvoiceException(string message) : base(message)
        {
        } 

        ///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1204"> 
		///		<ExpectedInput>Message input string and exception</ExpectedInput>
		///		<ExpectedOutput>Valid Invoice exception class with input string and exception</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1747"> 
		///		<ExpectedInput>Null string and exception</ExpectedInput>
		///		<ExpectedOutput>Generic error message and null inner exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// InvoiceException class constructor
		/// </summary>
        /// <param name="message">string</param>
        /// <param name="inner">exception</param>
        public InvoiceException(string message, Exception inner) : base(message, inner)
        {
        }
	}
}
